<?php

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Route;

if (!App::isProduction()) {
    Route::group(
        [
            'namespace'  => 'Inside\Documentation\Http\Controllers',
            'prefix'     => 'api/v1',
            'middleware' => [],
        ],
        function ($router) {
            $router->get('cypress/start', ['uses' => 'CypressController@start', 'middleware' => ['auth:jwt']]);
            $router->get('cypress/factory', ['uses' => 'CypressController@factory', 'middleware' => ['auth:jwt']]);
            $router->get('cypress/image', ['uses' => 'CypressController@getImage', 'middleware' => ['auth:api']]);
            $router->get('cypress/file', ['uses' => 'CypressController@getFile', 'middleware' => ['auth:api']]);
            $router->post('cypress/cleanup', ['uses' => 'CypressController@cleanup', 'middleware' => ['auth:api']]);
            $router->put(
                'cypress/type/config',
                ['uses' => 'CypressController@updateContentTypeConfig', 'middleware' => ['auth:jwt']]
            );
            $router->put(
                'cypress/field/config',
                ['uses' => 'CypressController@updateFieldConfig', 'middleware' => ['auth:jwt']]
            );
        }
    );

    Route::group(
        [
            'namespace'  => 'Inside\Documentation\Http\Controllers',
            'prefix'     => 'api/v1',
            'middleware' => 'auth.maecia',
        ],
        function ($router) {
            $router->get('documentation', ['uses' => 'DocumentationController@index']);
            $router->get('swagger', ['uses' => 'DocumentationController@swagger']);

            $router->get(
                'docs/{jsonFile}',
                [
                    'as'   => 'documentation.docs',
                    'uses' => 'DocumentationController@docs',
                ]
            );

            $router->get(
                'docs/assets/{asset}',
                [
                    'as'   => 'documentation.asset',
                    'uses' => 'AssetController@index',
                ]
            );
        }
    );
}
