<?php

namespace Inside\Documentation\Console\Commands;

use Inside\Authentication\Models\Token;
use Inside\Console\Command;
use Inside\Documentation\Facades\Cypress;
use Inside\Support\Str;

class CleanupTestsCommand extends Command
{
    protected $name = 'inside:tests:cleanup';

    protected $description = 'Supprime les données de tests';

    public function handle(): void
    {
        $this->writeln('Détection d\'ancien utilisateur de tests non nettoyé');
        $tokens = Token::where('authenticator', 'cypress')->get();
        foreach ($tokens as $token) {
            if ($token->user !== null && $token->user->email !== null && !Str::endsWith($token->user->email, '@maecia.com')) {
                $userUuid = $token->user->uuid;
                $this->write('Mise en suppression du compte de test <fg=cyan>' . $userUuid . '</fg=cyan> et de ses contenus');
                $result = Cypress::cleanUp($token->user, false);
                $this->writeResult(in_array($userUuid, $result['users']));
            }
        }
    }
}
