<?php

declare(strict_types=1);

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => '\Inside\Http\Controllers',
        'middleware' => 'auth:jwt',
    ],
    function ($route) {
        $route->get('monitor/check', 'MonitorController@check');
    }
);

Route::group(
    [
        'namespace'  => '\Inside\Http\Controllers',
        'prefix'     => 'admin',
        'middleware' => ['auth.backoffice.access:system'],
    ],
    function ($router) {
        // Mode maintenance
        $router->get(
            'maintenance',
            function () {
                $dotenv = cms_base_path('.env');

                if (File::exists($dotenv)) {
                    $content = File::get($dotenv);

                    File::put(
                        $dotenv,
                        str_replace(
                            'APP_DEBUG='.(env('APP_DEBUG') ? 'true' : 'false'),
                            'APP_DEBUG='.(env('APP_DEBUG') ? 'false' : 'true'),
                            $content
                        )
                    );
                }
            }
        );

        // Queue / Worker stuff
        $router->get('worker/list', ['uses' => 'Admin\QueueController@list']);
        $router->post('worker/ping/{workerName}', ['uses' => 'Admin\QueueController@pingWorker']);
        $router->get('worker/pong/{workerName}', ['uses' => 'Admin\QueueController@pongWorker']);
        $router->get('queue/stats/{workerName}', ['uses' => 'Admin\QueueController@queueStats']);
        $router->get('queue/failed/{workerName}', ['uses' => 'Admin\QueueController@queueGetFailed']);
        $router->post('queue/flush/failed', ['uses' => 'Admin\QueueController@queueFlushFailed']);
        $router->post('queue/restart', ['uses' => 'Admin\QueueController@queueRestart']);
        $router->get('pm2/status', ['uses' => 'Admin\QueueController@getPm2Status']);

        // General Tools
        $router->get('route/list', ['uses' => 'AdminController@getRouteList']);
        $router->post('cache/clear', ['uses' => 'AdminController@cacheClear']);
        $router->post('route/clear', ['uses' => 'AdminController@routeClear']);
        $router->post('version/reload', ['uses' => 'AdminController@reloadVersion']);
        $router->get('package/list', ['uses' => 'AdminController@getPackages']);
        $router->post('index/rebuild', ['uses' => 'AdminController@indexRebuild']);
        $router->post('index/rebuild/missing', ['uses' => 'AdminController@indexMissingContents']);
        $router->post('models/rebuild', ['uses' => 'AdminController@modelsRebuild']);
        $router->post('images/generate', ['uses' => 'AdminController@imagesGenerate']);
        $router->post('inside/cleanup', ['uses' => 'AdminController@cleanup']);
        $router->post('inside/database/cleanup', ['uses' => 'AdminController@cleanupDatabase']);
        $router->post('email/test', ['uses' => 'AdminController@testEmail']);
        $router->post('opcache/clear', ['uses' => 'AdminController@opcacheClear']);

        // Logs
        $router->get('logs', ['uses' => 'Admin\LogController@getLogs']);
        $router->get('logs/debug', ['uses' => 'Admin\LogController@getDebugLogs']);

        // Exports
        $router->get('layouts/export', ['uses' => 'Admin\ExportImportController@exportLayoutsToZip']);
        $router->post('layouts/import', ['uses' => 'Admin\ExportImportController@importLayoutsFromZip']);
        $router->get('inside/export', ['uses' => 'Admin\ExportImportController@exportInsideToZip']);
        $router->post('inside/import', ['uses' => 'Admin\ExportImportController@importInsideFromZip']);

        // Broadcasting
        $router->post('broadcasting/test/birthday', ['uses' => 'Admin\BroadcastingController@triggerBirthday']);
        $router->post('broadcasting/test/export', ['uses' => 'Admin\BroadcastingController@triggerExportCompleted']);
        $router->post('broadcasting/test/reaction', ['uses' => 'Admin\BroadcastingController@triggerReaction']);
        $router->post('broadcasting/test/notification', ['uses' => 'Admin\BroadcastingController@triggerNotification']);

        // Routes
        $router->get('routes/index', ['uses' => 'Admin\RouteController@index']);
        $router->post('routes/clear', ['uses' => 'Admin\RouteController@clear']);
        $router->post('routes/cache', ['uses' => 'Admin\RouteController@cache']);
    }
);

Route::group(
    [
        'namespace'  => '\Inside\Http\Controllers',
    ],
    function ($router) {
        $router->get('layouts/get', ['uses' => 'Admin\ExportImportController@exportLayoutsToJson']);
    }
);
