<?php

return [
    'all_right_reserved' => 'Todos los derechos reservados',
    'empty' => 'No tienes notificaciones en este momento',
    'markAllAsRead' => 'Marcar todo como leído',
    'seeAll' => 'Ver todas las notificaciones',
    'receive' => 'Recibir notificaciones',
    'add' => 'Agregar una notificación',
    'edit' => 'Editar',
    'back' => 'Atrás',
    'section' => [
        'web' => 'Web',
        'mail' => 'Correo',
    ],
    'user' => [
        'login' => [
            'first' => [
                'text' => 'Bienvenido <span class="bold">:author.firstname :author.lastname</span>',
            ],
        ],
    ],
    'content' => [
        'news' => [
            'featured' => [
                'title' => 'Publicación de una noticia destacada',
                'text' => 'La noticia <span class="bold">:model.title</span> ahora es destacada',
            ],
        ],
    ],
    'activity' => [
        'create' => [
            'comment' => [
                'news' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> ha comentado la noticia <span class="bold">:model.title</span>',
                ],
                'events' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> ha comentado el evento <span class="bold">:model.title</span>',
                ],
            ],
            'documents' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha añadido el recurso <span class="bold">:model.title</span>',
            ],
            'news' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha añadido la noticia <span class="bold">:model.title</span>',
            ],
            'events' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha añadido el evento <span class="bold">:model.title</span>',
            ],
        ],
    ],
    'create' => [
        'news' => [
            'featured' => [
                'title' => 'Publicación de una noticia destacada',
                'text' => 'La noticia <span class="bold">:model.title</span> ahora es destacada',
                'mail' => [
                    'title' => 'La publicación en línea de una noticia destacada',
                ],
            ],
            'follow' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha creado la noticia <span class="bold">:model.title</span>',
            ],
            'pending' => [
                'title' => 'Noticia pendiente de validación',
            ],
        ],
        'comment' => [
            'content' => [
                'title' => 'Creación de un comentario en uno de tus contenidos.',
                'description' => 'Alguien ha publicado un comentario en uno de tus contenidos.',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha publicado un comentario en tu artículo <span class="bold">:model.title</span>',
                'documents' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> ha publicado un comentario en tu documento <span class="bold">:model.title</span>',
                ],
                'news' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> ha publicado un comentario en tu noticia <span class="bold">:model.title</span>',
                ],
                'events' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> ha publicado un comentario en tu evento  <span class="bold">:model.title</span>',
                ],
            ],
            'comment' => [
                'title' => 'Creación de un comentario o un post en un muro de discusión.',
                'description' => 'Alguien responde a uno de tus comentarios.',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha respondido a tu comentario en el artículo <span class="bold">:model.title</span>',
                'documents' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> ha respondido a tu comentario en el documento <span class="bold">:model.title</span>',
                ],
                'news' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> ha respondido a tu comentario en la noticia <span class="bold">:model.title</span>',
                ],
                'events' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> ha respondido a tu comentario en el evento  <span class="bold">:model.title</span>',
                ],
            ],
        ],
        'newsletters' => [
            'sent' => [
                'mail' => [
                    'title' => 'Recibe el boletín',
                    'description' => 'Suscríbete al boletín y recíbelo por correo en cada publicación',
                ],
            ],
        ],
    ],
    'update' => [
        'news' => [
            'featured' => [
                'title' => 'Una publicación existente es destacada',
                'text' => 'La noticia <span class="bold">:model.title</span> ahora es destacada',
                'mail' => [
                    'title' => 'La publicación en línea de una noticia destacada',
                ],
            ],
        ],
    ],
    'comment' => [
        'create' => [
            'title' => 'Creación de un comentario o un post en un muro de discusión',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> ha comentado <span class="bold">:model.title</span>',
        ],
        'answer' => [
            'title' => 'Cuando alguien responde a tu comentario.',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> ha respondido a tu comentario <span class="bold">[:model.title]</span>',
        ],
    ],
    'reaction' => [
        'follow' => [
            'title' => 'Cuando alguien te sigue',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> ha comenzado a seguirte',
        ],
        'like' => [
            'title' => 'Cuando a alguien le gusta uno de tus contenidos',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> le gustó <span class="bold">:model.title</span>',
            'comment' => [
                'title' => 'Cuando a alguien le gusta uno de tus comentarios',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> le gustó uno de tus comentarios',
            ],
        ],
        'join' => [
            'events' => [
                'title' => 'Cuando alguien se une a un evento',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> se ha unido a tu evento <span class="bold">:model.title</span>',
            ],
        ],
    ],
    'custom' => [
        'report' => [
            'comments' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha reportado un comentario inapropiado',
            ],
            'documents' => [
                'title' => 'Cuando alguien reporta un documento',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha reportado el documento <span class="bold">:model.title</span> como obsoleto',
                'mail' => [
                    'title' => 'Reportar un documento',
                ],
            ],
        ],
    ],
    'group' => [
        'document' => [
            'text' => '<span class="bold">:author.firstname :author.lastname</span> ha añadido un nuevo documento en el grupo <span class="bold">:model.groups.data.0.title</span>',
        ],
        'post' => [
            'text' => '<span class="bold">:author.firstname :author.lastname</span> ha añadido un nuevo comentario en el grupo <span class="bold">:model.groups.data.0.title</span>',
            'answer' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha respondido a tu comentario en el grupo <span class="bold">:model.groups.data.0.title</span>',
            ],
        ],
        'invited' => [
            'text' => '<span class="bold">:author.firstname :author.lastname</span> te ha añadido en el grupo <span class="bold">:model.title</span>',
        ],
        'member' => [
            'pending' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> ha solicitado unirse al grupo <span class="bold">:model.title</span>',
            ],
        ],
    ],
    'birthday' => [
        'text' => '<span class="bold">:author.firstname :author.lastname</span> te desea un feliz cumpleaños',
    ],
];
