@php

$type = $model->content_type;
$categoryType = $type . 'Categories';
$color = setting('general', 'color_secondary', config('notify.manual_notifications.enhanced_notifications_types_and_fields')[$type]['options']['default_category_color'] ?? '#A7A7A7');
$category = null;

if (isset($model->{$categoryType}) && $model->{$categoryType}->isNotEmpty()) {
    $color = $model->{$categoryType}->first()->color ?? $color;
    $category = $model->{$categoryType}->first()->title;
}

@endphp

@component('mail::notification')

{{-- Intro Lines --}}
@foreach ($introLines as $line)
{{ $line }}
@endforeach

@component('mail::externalNotificationEmail', [
  'slug' => !empty($model->external_notif_link) ? url($model->external_notif_link) : url(\Illuminate\Support\Arr::first($model->slug)) ,
  'image' => $image,
  'model' => $model,
  'color' => $color,
  'category' => $category
  ])
@endcomponent

{{-- Action Button --}}
@isset($actionText)
@component('mail::buttonExternalNotification', ['url' => $actionUrl])
{{ $actionText }}
@endcomponent
@endisset

@endcomponent
