@php
    use Inside\Settings\Models\Setting;
@endphp
@component('mail::layout')
    {{-- Header --}}
    @slot('header')
        @component('mail::header', ['url' => config('app.url')])
            {{ config('app.name') }}
        @endcomponent
    @endslot

    {{-- Body --}}
    {{ $slot }}

    {{-- Subcopy --}}
    @isset($subcopy)
        @slot('subcopy')
            @component('mail::subcopy')
                {{ $subcopy }}
            @endcomponent
        @endslot
    @endisset

    {{-- Footer --}}
    @slot('footer')
        @component('mail::footer')
            &copy; {{ date('Y') }} {{ Setting::where('key', 'meta_title')->first()?->value ?? config('app.name') }}. @lang('notifications.all_right_reserved', [], $locale ?? null).
        @endcomponent
    @endslot
@endcomponent
