@php
    use Illuminate\Support\Facades\App;
    $assetPath    = '/themes/custom/inside-drupal-theme/assets';
    $documentRoot = filter_input(INPUT_SERVER, 'DOCUMENT_ROOT', FILTER_SANITIZE_STRING);
    $buildTime    = file_exists($documentRoot . $assetPath) ? filemtime($documentRoot . $assetPath) ?? 0 : 0;
    use Inside\Settings\Models\Setting;
@endphp
    <!DOCTYPE html>
<html lang="{{ App::getLocale() }}" dir="ltr">
<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width,user-scalable=no,initial-scale=1.0,maximum-scale=1.0"/>
    <meta name="HandheldFriendly" content="true"/>

    <meta name="application-name" content="{{ Setting::where(['key' => 'meta_title', 'group' => 'general'])->first()?->value ?? env('APP_NAME') }}"/>
    <meta name="mobile-web-app-capable" content="yes"/>
    <meta name="theme-color" content="#ffffff"/>

    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <meta name="apple-mobile-web-app-title" content="{{ Setting::where(['key' => 'meta_title', 'group' => 'general'])->first()?->value ?? env('APP_NAME') }}"/>
    <meta name="apple-mobile-web-app-status-bar-style" content="#ffffff"/>

    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="format-detection" content="telephone=no"/>

    <meta name="robots" content="noindex"/>
    <meta name="description" content="{{ Setting::where(['key' => 'meta_title', 'group' => 'general'])->first()?->value ?? env('APP_NAME') }}"/>

    <title>
        {{ Setting::where(['key' => 'meta_title', 'group' => 'general'])->first()?->value ?? env('APP_NAME') }}
    </title>

    <link rel="stylesheet" href="/themes/custom/inside-drupal-theme/assets/theme-vars.css">

    <x-logo-header :path="$assetPath" :build="$buildTime"/>
    {!! Inside::css() !!}
    {!! Inside::headerJs() !!}
</head>
<body>
<div id="app"></div>
{!! Inside::script() !!}
{!! Inside::js() !!}
@if(config('permission.debug'))
    <style>
        body {
            margin-bottom: 35px; /* Ajuste à la hauteur du bandeau */
        }

        #permission-banner {
            background-color: #02b9a7;
            color: white;
            font-weight: bold;
            text-align: center;
            padding: 10px;
            position: fixed;
            bottom: 0;
            width: 100%;
            z-index: 4900;
            box-shadow: 0 -2px 5px rgba(0, 0, 0, 0.2);
        }
    </style>

    <div id="permission-banner">
        PERMISSION {{ setting('permission', 'system_v2_enabled', false) ? 'V2' : 'V1' }}
    </div>
@endif
</body>
</html>
