@php
    use Inside\Settings\Models\Setting;
@endphp
@component('mail::message')

{{-- Intro Lines --}}
@foreach ($introLines as $line)
{!! $line !!}

@endforeach

{{-- Salutation --}}
@if (!empty(trim($salutation)) && trim($salutation) !== 'mail.password_reset.salutation')
{{ $salutation }}
@endif

{{-- Action Button --}}
@if(isset($actionText) && !empty($actionText))
@component('mail::button', ['url' => $actionUrl])
{{ $actionText }}
@endcomponent
@endif

{{-- Outro Lines --}}
@foreach ($outroLines as $line)
{!! $line !!}

@endforeach

{{-- Subcopy --}}
@if(isset($actionText) && !empty($actionText))
@component('mail::subcopy', ['actionUrl' => $actionUrl])
@lang('notifications.mail.subcopy', ['actionText' => $actionText], $locale ?? null)
@endcomponent
@endif

{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ Setting::where('key', 'meta_title')->first()?->value ?? config('app.name') }}. @lang('notifications.all_right_reserved', [], $locale ?? null).<br/>
<i>Powered by <a href="https://www.intranet-inside.com" style="text-decoration: none; color: #FF7C49;">Intranet Inside</a></i>
@endcomponent
@endslot
@endcomponent
