<?php

declare(strict_types=1);

return [
    /*
    |--------------------------------------------------------------------------
    | Session Driver
    |--------------------------------------------------------------------------
    */
    'driver' => 'database',
    'table' => 'inside_sessions',
    'lottery' => [2, 100],
    'expire_on_close' => false,
    'encrypt' => true,

    /*
    |--------------------------------------------------------------------------
    | Session Lifetime
    |--------------------------------------------------------------------------
    */
    'lifetime' => 60 * 24 * 30, // 30 days
    'longer_lifetime' => 60 * 24 * 30 * 3, // 3 months
    'sso_lifetime' => 60 * 24 * 30 * 3, // 3 months

    /*
    |--------------------------------------------------------------------------
    | Cookie
    |--------------------------------------------------------------------------
    */
    'domain' => env('INSIDE_COOKIE_DOMAIN'),
    'cookie' => env('SESSION_COOKIE', '_inside_session'),
    'secure' => env('SECURE_COOKIE', str_starts_with(env('APP_URL', 'http://localhost'), 'https://')),

    'path' => '/',
    'http_only' => true,
    'same_site' => 'None',
];
