<?php

use Illuminate\Console\Scheduling\Schedule;

return [
    'schedule' => [
        'log_cleaner'             => function (Schedule $scheduler) {
            $scheduler->job(new Inside\Jobs\LogCleaner())->daily();
        },
        'tmp_cleaner'             => function (Schedule $scheduler) {
            $scheduler->job(new Inside\Jobs\TmpCleaner())->daily();
        },
        'restart_worker'          => function (Schedule $scheduler) {
            // Nicely restart workers to free memory
            $scheduler->command('queue:restart')->dailyAt('4:00');
        },
        'cleanup_failed_jobs' => function (Schedule $scheduler) {
            $scheduler->command('inside:failed-jobs:cleanup')->dailyAt('20:00');
        },
        'cleanup_expired_notifications' => function (Schedule $scheduler) {
            $scheduler->command('notif:clean:expired')->dailyAt('21:00');
        },
    ],
];
