<?php

return [
    'default' => env('QUEUE_DRIVER', 'redis'),
    'connections' => [
        'sync' => [
            'driver' => 'sync',
        ],
        'lts' => [
            'driver' => 'database',
            'table' => 'inside_jobs',
            'queue' => env('LTS_QUEUE', env('APP_CODE', 'sid2').'_lts'),
            'retry_after' => 310,
        ],
        'beanstalkd' => [
            'driver' => 'beanstalkd',
            'host' => 'localhost',
            'queue' => 'default',
            'retry_after' => 310,
        ],
        'sqs' => [
            'driver' => 'sqs',
            'key' => 'your-public-key',
            'secret' => 'your-secret-key',
            'queue' => 'your-queue-url',
            'region' => 'us-east-1',
        ],
        'redis' => [
            'driver' => 'redis',
            'connection' => env('QUEUE_REDIS_CONNECTION', 'queue'),
            'queue' => env('REDIS_QUEUE', env('APP_CODE', 'sid2').'_default'),
            'retry_after' => 310,
        ],
    ],

    'failed' => [
        'database' => env('DB_CONNECTION', 'mysql'),
        'table' => env('QUEUE_FAILED_TABLE', 'failed_jobs'),
    ],

];
