<?php

$url = parse_url(env('APP_URL'));
$host = $url['host'] ?? 'localhost';

return [
    'encoding'      => 'UTF-8',
    'finalize'      => true,
    'cachePath'     => cms_base_path(config('app.app_storage_path').'/purifier'),
    'cacheFileMode' => 0755,
    'settings'      => [
        'default'           => [
            'HTML.Doctype'             => 'HTML 4.01 Transitional',
            'HTML.Allowed'             => 'div[style],h1[style|class],h2[style|class],h3[style|class],h4[style|class],h5[style|class],h6[style|class],strike,b,strong[class],i,iframe[src|width|height|frameborder|scrolling|style|allowfullscreen],s[class],sub,sup,em[class],u[class],a[href|target|title|class],ul[style|class],ol[start|style],li[style|class],p[style|class],br,span[style|class],img[width|height|alt|src|style|class],table[style|cellspacing|cellpadding|border|align],th[colspan|colwidth|style],tr,td[style|colwidth|colspan|rowspan|class],tbody,thead,blockquote,code[class],pre[class],hr[class]',
            'CSS.AllowedProperties'    => 'border-collapse,border,display,float,font,font-size,font-weight,font-style,font-family,text-decoration,padding-left,color,background,background-color,text-align,margin-left,margin-right,width,height,border-color,list-style-type,vertical-align',
            'CSS.AllowTricky'          => true,
            'AutoFormat.AutoParagraph' => true,
            //   'AutoFormat.RemoveEmpty.Predicate' => ['table'],
            'HTML.SafeIframe'          => true,
            'Attr.AllowedFrameTargets' => ['_blank'],
            'URI.AllowedSchemes'       => ['https' => true, 'http' => true, 'data' => true, 'mailto' => true, 'file' => true],
            'URI.SafeIframeRegexp'     => '%^.*$%',
        ],
    ],
];
