<?php

use Monolog\Handler\NullHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Handler\SyslogUdpHandler;

return [

    'default' => env('LOG_CHANNEL', 'stack'),

    'deprecations' => [
        'driver' => env('LOG_DEPRECATIONS_CHANNEL', 'null'),
        'trace' => false,
    ],

    'channels' => [
        'stack' => [
            'driver'            => 'stack',
            'channels'          => ['daily'],
            'ignore_exceptions' => false,
        ],

        'monitoring' => [
            'driver'            => 'stack',
            'channels'          => ['daily', 'slack'],
            'ignore_exceptions' => false,
        ],

        'import' => [
            'driver' => 'daily',
            'path' => storage_path('logs/import.log'),
            'level' => 'debug',
            'days' => '31',
            'tap' => [Inside\Logging\DailyFilenames::class],
        ],

        'single' => [
            'driver' => 'single',
            'path'   => cms_base_path(env('APP_LOG_PATH', 'storage/logs').'/inside.log'),
            'level'  => 'debug',
        ],

        'daily' => [
            'driver' => 'daily',
            'path'   => cms_base_path(env('APP_LOG_PATH', 'storage/logs').'/inside.log'),
            'level'  => env('APP_DEBUG', false) ? 'debug' : 'info',
            'days'   => 14,
            'tap' => [Inside\Logging\DailyFilenames::class],
        ],

        'slack' => [
            'driver'   => 'slack',
            'url'      => env('LOG_SLACK_WEBHOOK_URL'),
            'username' => env('APP_NAME'),
            'emoji'    => ':boom:',
            'level'    => env('LOG_SLACK_LEVEL', 'error'),
            'short' => true,
        ],

        'front_slack' => [
            'driver'   => 'slack',
            'url'      => env('LOG_FRONT_SLACK_WEBHOOK_URL'),
            'username' => env('APP_NAME'),
            'emoji'    => ':boom:',
            'level'    => env('LOG_FRONT_SLACK_LEVEL', 'error'),
            'short' => true,
        ],

        'papertrail' => [
            'driver'       => 'monolog',
            'level'        => 'debug',
            'handler'      => SyslogUdpHandler::class,
            'handler_with' => [
                'host' => env('PAPERTRAIL_URL'),
                'port' => env('PAPERTRAIL_PORT'),
            ],
        ],

        'stderr' => [
            'driver'    => 'monolog',
            'handler'   => StreamHandler::class,
            'formatter' => env('LOG_STDERR_FORMATTER'),
            'with'      => [
                'stream' => 'php://stderr',
            ],
        ],

        'syslog' => [
            'driver' => 'syslog',
            'level'  => 'debug',
        ],

        'errorlog' => [
            'driver' => 'errorlog',
            'level'  => 'debug',
        ],

        'null' => [
            'driver'  => 'monolog',
            'handler' => NullHandler::class,
        ],

        'emergency' => [
            'path' => cms_base_path(env('APP_LOG_PATH', 'storage/logs').'/inside-emergency.log'),
        ],
    ],

];
