<?php

return [
    'default' => env('BROADCAST_DRIVER', 'redis'),
    'laravel_echo_server' => [
        'enabled' => env('INSIDE_BROADCASTING_ENABLED', false),
        'path'    => env('INSIDE_LARAVEL_ECHO_SERVER_PATH', 'laravel-echo-server'),
    ],
    'connections' => [
        'pusher' => [
            'driver'  => 'pusher',
            'key'     => env('PUSHER_APP_KEY'),
            'secret'  => env('PUSHER_APP_SECRET'),
            'app_id'  => env('PUSHER_APP_ID'),
            'options' => [
                'cluster' => env('PUSHER_APP_CLUSTER'),
                'useTLS'  => true,
            ],
        ],
        'redis' => [
            'driver'     => 'redis',
            'connection' => 'broadcast',
        ],
        'log' => [
            'driver' => 'log',
        ],
        'null' => [
            'driver' => 'null',
        ],
    ],
];
