<?php

namespace Inside\Support\View\Compilers\Concerns;

trait CompilesInjections
{
    /**
     * Compile the inject statements into valid PHP.
     *
     * @param string $expression
     * @return string
     */
    protected function compileInject($expression)
    {
        /** @var string $str */
        $str = preg_replace("/[\(\)\\\"\']/", '', $expression);

        $segments = explode(',', $str);

        $variable = trim($segments[0]);

        $service = trim($segments[1]);

        return "<?php \${$variable} = app('{$service}'); ?>";
    }
}
