<?php

namespace Inside\Support\SerializableClosure\Serializers;

use Closure;
use Inside\Contracts\Support\Serializable;
use Inside\Contracts\Support\SerializerSigner;
use Inside\Exceptions\Serializer\InvalidSignatureException;
use Inside\Exceptions\Serializer\MissingSecretKeyException;

class Signed implements Serializable
{
    public static ?SerializerSigner $signer = null;

    public function __construct(
        protected Closure $closure
    ) {
    }

    public function __invoke(): mixed
    {
        return call_user_func_array($this->closure, func_get_args());
    }

    public function getClosure(): Closure
    {
        return $this->closure;
    }

    /**
     * @throws MissingSecretKeyException
     */
    public function __serialize(): array
    {
        if (! static::$signer) {
            throw new MissingSecretKeyException();
        }

        return static::$signer->sign(
            serialize(new Native($this->closure))
        );
    }

    /**
     * @throws InvalidSignatureException
     */
    public function __unserialize(array $signature): void
    {
        if (static::$signer && ! static::$signer->verify($signature)) {
            throw new InvalidSignatureException();
        }

        /** @var Serializable $serializable */
        $serializable = unserialize($signature['serializable']);

        $this->closure = $serializable->getClosure();
    }
}
