<?php

namespace Inside\Support\SerializableClosure;

use Closure;
use Inside\Contracts\Support\Serializable;
use Inside\Exceptions\Serializer\InvalidSignatureException;
use Inside\Support\SerializableClosure\Serializers\Signed;
use Inside\Support\SerializableClosure\Signers\Hmac;

class SerializableClosure
{
    protected Serializable $serializable;

    public function __construct(Closure $closure)
    {
        $this->serializable = Signed::$signer
            ? new Signed($closure)
            : new Serializers\Native($closure);
    }

    public function __invoke(): mixed
    {
        return call_user_func_array($this->serializable, func_get_args());
    }

    public function getClosure(): Closure
    {
        return $this->serializable->getClosure();
    }

    /**
     * Sets the serializable closure secret key.
     */
    public static function setSecretKey(?string $secret): void
    {
        Signed::$signer = $secret ? new Hmac($secret) : null;
    }

    public static function transformUseVariablesUsing(?Closure $transformer): void
    {
        Serializers\Native::$transformUseVariables = $transformer;
    }

    public static function resolveUseVariablesUsing(?Closure $resolver): void
    {
        Serializers\Native::$resolveUseVariables = $resolver;
    }

    public function __serialize(): array
    {
        return [
            'serializable' => $this->serializable,
        ];
    }

    /**
     * @throws InvalidSignatureException
     */
    public function __unserialize(array $data): void
    {
        if (Signed::$signer && ! $data['serializable'] instanceof Signed) {
            throw new InvalidSignatureException();
        }

        $this->serializable = $data['serializable'];
    }
}
