<?php

namespace Inside\Support\Requirements;

use Dompdf\Exception;
use Illuminate\Support\Str;
use Inside\Settings\Facades\Settings;
use Inside\Support\InsidePackage;

class OptionRequirement
{
    /**
     * @param  InsidePackage  $package
     * @param  \Closure  $next
     * @param mixed $params
     * @return \Closure|false
     * @throws Exception
     */
    public function handle(InsidePackage $package, \Closure $next, $params)
    {
        if (! is_string($params)) {
            throw new Exception('Option Requirement params must be a string');
        }

        if (env(Str::upper('inside_'.$params.'_enabled')) === false) {
            return false;
        }

        return $next($package);
    }
}
