<?php

namespace Inside\Support;

use Dotenv\Dotenv;
use Dotenv\Exception\InvalidFileException;
use Illuminate\Support\Env;
use Inside\Application;
use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * Class LoadEnvironmentVariables
 */
class LoadEnvironmentVariables
{
    /**
     * LoadEnvironmentVariables constructor.
     */
    public function __construct(
        protected string $filePath,
        protected ?string $fileName = null
    ) {
    }

    public function bootstrap(Application $application): void
    {
        if (env('APP_KEY') !== null) {
            return; // dot env alread loaded
        }
        try {
            $this->createDotenv($application)->safeLoad();
        } catch (InvalidFileException $e) {
            $this->writeErrorAndDie(
                [
                    'The environment file is invalid!',
                    $e->getMessage(),
                ]
            );
        }
    }

    protected function createDotenv(Application $application): Dotenv
    {
        return Dotenv::create(
            $application->environmentPath(),
            $application->environmentFile(),
            Env::getFactory()
        );
    }

    /**
     * @param  array  $errors
     */
    protected function writeErrorAndDie(array $errors): void
    {
        $output = (new ConsoleOutput())->getErrorOutput();

        foreach ($errors as $error) {
            $output->writeln($error);
        }

        die(1);
    }
}
