<?php

namespace Inside\Support;

use Illuminate\Support\Facades\Event;
use Inside\Import\Providers\UserImportServiceProvider;
use Inside\Providers\ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /** @var string[][] */
    protected array $listen = [];

    /** @var string[] */
    protected array $subscribe = [];

    public function boot(): void
    {
        $provider = (new \ReflectionClass($this))->getFileName();
        $this->loadMigrationsFrom(dirname($provider).'/../../database/migrations');
        foreach ($this->listen as $event => $listeners) {
            foreach (array_unique($listeners) as $listener) {
                Event::listen($event, $listener);
            }
        }

        foreach ($this->subscribe as $subscriber) {
            Event::subscribe($subscriber);
        }
    }
}
