<?php

namespace Inside\Support;

use Closure;

class EnvironmentDetector
{
    public function detect(Closure $callback, ?array $consoleArgs = null): string
    {
        if (! is_null($consoleArgs)) {
            return $this->detectConsoleEnvironment($callback, $consoleArgs);
        }

        return $this->detectWebEnvironment($callback);
    }

    protected function detectWebEnvironment(Closure $callback): string
    {
        return $callback();
    }

    protected function detectConsoleEnvironment(Closure $callback, array $args): string
    {
        if (! is_null($value = $this->getEnvironmentArgument($args))) {
            return $value;
        }

        return $this->detectWebEnvironment($callback);
    }

    protected function getEnvironmentArgument(array $args): ?string
    {
        foreach ($args as $i => $value) {
            if ($value === '--env') {
                return $args[$i + 1] ?? null;
            }

            if (str_starts_with($value, '--env')) {
                return head(array_slice(explode('=', $value), 1));
            }
        }

        return null;
    }
}
