<?php

namespace Inside\Support;

class BackofficeEntry
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var array
     */
    protected $requirements = [];

    /**
     * @param mixed $entry
     */
    public function __construct($entry)
    {
        if (is_string($entry)) {
            $this->name = $entry;
        } else {
            $this->name = array_key_first($entry);
            if (isset($entry[$this->name]['requirements'])) {
                $this->requirements = $entry[$this->name]['requirements'];
            }
        }
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getRequirements(): array
    {
        return $this->requirements;
    }
}
