<?php

namespace Inside\Services\Monitor\Checkers;

use Inside\Authentication\Models\User;
use Throwable;

class UserDirectoryChecker extends Checker implements CheckerInterface
{
    use HasLimit;

    /**
     * @var int
     */
    protected $limit = 50;

    public function isHealthy(): bool
    {
        return isset($this->lastCheckData['users']) && $this->lastCheckData['users'] > $this->getLimit();
    }

    public function processRunCheck(): bool
    {
        try {
            $this->lastCheckData['users'] = User::where('status', true)
                ->whereHas('information', function ($query) {
                    $query->where('is_maintenance', false);
                })
                ->count();
        } catch (Throwable $exception) {
            return false;
        }

        return true;
    }
}
