<?php

namespace Inside\Services\Monitor\Checkers;

class MemoryChecker extends Checker implements CheckerInterface
{
    use HasLimit;

    /**
     * @var int
     */
    protected $limit = 95;

    public function isSupported(): bool
    {
        return ! windows_os();
    }

    public function processRunCheck(): bool
    {
        try {
            $this->lastCheckData['memory_usage'] = $this->getMemoryUsage();

            return true;
        } catch (\Throwable $e) {
            return false;
        }
    }

    public function isHealthy(): bool
    {
        return isset($this->lastCheckData['memory_usage']) && $this->lastCheckData['memory_usage'] < ($this->getLimit() / 100.0);
    }

    protected function getMemoryUsage(): float
    {
        $fh = fopen('/proc/meminfo', 'r');
        $memInfo = '';

        if ($fh) {
            while ($line = fgets($fh)) {
                $memInfo .= $line;
            }
            fclose($fh);
        }

        preg_match_all('/(\d+)/', $memInfo, $pieces);

        $this->lastCheckData['memory_total'] = $pieces[0][0] * 1024;
        $this->lastCheckData['memory_used'] = ($pieces[0][0] - $pieces[0][2]) * 1024;
        $this->lastCheckData['memory_available'] = $pieces[0][2] * 1024;
        $this->lastCheckData['memory_total_h'] = inside_bytes_to_human($this->lastCheckData['memory_total']);
        $this->lastCheckData['memory_used_h'] = inside_bytes_to_human($this->lastCheckData['memory_used']);
        $this->lastCheckData['memory_available_h'] = inside_bytes_to_human($this->lastCheckData['memory_available']);

        return round(($pieces[0][0] - $pieces[0][2]) / $pieces[0][0], 3);
    }
}
