<?php

namespace Inside\Services\Monitor\Checkers;

use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;

trait HasCommand
{
    protected string $command;

    protected ?int $timeout = 10;

    protected mixed $commandResult;

    protected function setCommand(string $command): void
    {
        $this->command = $command;
    }

    protected function getCommand(): string
    {
        return windows_os() ? str_replace('/', '\\', $this->command) : $this->command;
    }

    protected function setTimeout(?int $timeout): void
    {
        $this->timeout = $timeout;
    }

    protected function getTimeout(): ?int
    {
        return $this->timeout;
    }

    protected function getCommandResult(): mixed
    {
        return $this->commandResult;
    }

    protected function setCommandResult(mixed $commandResult): void
    {
        $this->commandResult = $commandResult;
    }

    protected function getProcess(): Process
    {
        $process = new Process([], cms_base_path());

        $process->setTimeout($this->getTimeout());

        $process->setCommandLine($this->getCommand());

        return $process;
    }

    protected function commandRun(): bool
    {
        try {
            $process = $this->getProcess();
            $process->run();

            if (! $process->isSuccessful()) {
                $this->setCommandResult($process->getErrorOutput());

                return false;
            }
            $this->setCommandResult($process->getOutput());
        } catch (ProcessFailedException $exception) {
            $this->setCommandResult($exception->getMessage());

            return false;
        }

        return true;
    }
}
