<?php

namespace Inside\Services;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Schema;
use Inside\Layout\Models\Layout;
use Inside\Layout\Models\LayoutPath;

/**
 * Inside ExportImport service.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ExportImportService
{
    /**
     * Import layouts
     *
     * @param Collection $data
     * @return int
     */
    public function importLayouts(Collection $data): int
    {
        // Empty old layouts
        LayoutPath::truncate();
        Schema::disableForeignKeyConstraints();

        Layout::truncate();
        Schema::enableForeignKeyConstraints();

        $count = 0;

        foreach ($data as $config) {
            if (empty($config->paths)) {
                continue;
            }
            $layout = new Layout();
            $layout->id = $config->id; // Id is used to get layout order and should be keep the same
            $layout->blocks = $config->blocks;
            $layout->layout = $config->layout;
            $layout->name = $config->name;
            $layout->option = $config->option ?? null;
            $layout->save();
            foreach ($config->paths as $path) {
                $layout->paths()->create(
                    [
                        'path' => $path->path,
                        'langcode' => $path->langcode,
                        'option' => $path->option ?? null,
                    ]
                );
                $count++;
            }
        }

        return $count;
    }
}
