<?php

namespace Inside\Providers;

use Exception;
use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Queue;
use Inside\Application;
use Inside\Facades\Package;
use Inside\Services\AliasLoader;
use Inside\Support\InsidePackage;

/**
 * Inside package discover service.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class PackageServiceProvider extends ServiceProvider
{
    private Collection $packages;

    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot(): void
    {
        $this->bootProviders();
    }

    /**
     * Register the application services.
     *
     * @return void
     * @throws Exception
     */
    public function register(): void
    {
        $this->booted(function () {
            AliasLoader::getInstance($this->app->getInsideAliases())->register();
        });

        $this->packages = Package::list();

        if ($this->packages->isEmpty()) {
            // First inside launch during Install - no package detection, nothing to start but inside
            return;
        }
        $this->registerProviders();
        $this->app->configure('mail');
    }

    /**
     * Register all providers
     *
     * @return void
     *
     * @throws Exception
     */
    private function registerProviders(): void
    {
        foreach ($this->packages as $package) {
            /** @var InsidePackage $package */
            if ($package->getType() != 'inside') {
                continue;
            }
            $package->setApplication($this->app);
            $package->registerProviders();
            if (! $this->app->routesAreCached()) {
                $package->loadRoutes();
            }
            $package->loadChannels();
            $package->loadConsoles();
            $package->loadLanguages();
            $package->addViewPath();
            $package->addMigrationPath();
        }
    }

    /**
     * Boot providers
     */
    private function bootProviders(): void
    {
        foreach ($this->packages as $package) {
            if ($package->getType() != 'inside') {
                continue;
            }
            $package->bootProviders();
        }
    }
}
