<?php

namespace Inside\Providers;

use Illuminate\Mail\Mailer;
use Illuminate\Mail\MailServiceProvider as BaseMailerServiceProvider;
use Illuminate\Mail\Markdown;

class MailServiceProvider extends BaseMailerServiceProvider
{
    protected function registerIlluminateMailer(): void
    {
        $this->app->singleton('mailer', function ($app) {
            $config = $app->make('config')->get('mail');

            if (env('MAIL_TLS_DONT_CHECK_CERTIFICATE', false) === true) {
                $config['stream'] = [
                    'ssl' => [
                        'allow_self_signed' => true,
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                    ],
                ];
                $app->make('config')->set('mail', $config);
            }

            $mailer = new Mailer(
                $app['view'],
                $app['swift.mailer'],
                $app['events']
            );

            if ($app->bound('queue')) {
                $mailer->setQueue($app['queue']);
            }

            foreach (['from', 'reply_to', 'to'] as $type) {
                $this->setGlobalAddress($mailer, $config, $type);
            }

            return $mailer;
        });
    }

    protected function registerMarkdownRenderer(): void
    {
        $this->app->singleton(Markdown::class, function ($app) {
            $config = $app->make('config');

            return new Markdown($app->make('view'), [
                'theme' => $config->get('mail.markdown.theme', 'default'),
                'paths' => array_merge($config->get('mail.markdown.paths', []), [
                    back_path('resources/views/vendor/mail'),
                    inside_core_path('resources/custom/views/vendor/mail'),
                ]),
            ]);
        });
    }
}
