<?php

namespace Inside\Models\Traits;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

trait TreeNode
{
    public function getParentId()
    {
        return $this->getAttributeValue('parent_id');
    }

    public function setParentId($value)
    {
        $this->attributes['parent_id'] = $value;

        return $this;
    }

    public function isRoot()
    {
        return is_null($this->getParentId());
    }

    protected function setParent($value)
    {
        $this->setParentId($value ? $value->getKey() : null)->setRelation('parent', $value);

        return $this;
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(get_class($this), 'parent_id')->setModel($this);
    }

    public function children()
    {
        return $this->hasMany(get_class($this), 'parent_id')->setModel($this);
    }
}
