<?php

namespace Inside\Logging;

use Monolog\Handler\RotatingFileHandler;

/**
 * Class DailyFilenames
 *
 * Get inside daily filename convention
 */
class DailyFilenames
{
    public function __invoke(Logger $logger): void
    {
        foreach ($logger->getHandlers() as $handler) {
            if ($handler instanceof RotatingFileHandler) {
                $handler->setFilenameFormat('{date}-{filename}', 'Y-m-d');
            }
        }
    }
}
