<?php

namespace Inside\Listeners;

use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Events\InsideBooted;
use Inside\Facades\Inside;

class AddJavascriptsToFrontend
{
    public function handle(InsideBooted $event): void
    {
        //  Prepare js

        // Add cookie js
        if (env('COOKIE_BANNER', false) && env('COOKIE_BANNER_UUID')) {
            $userLangcode = $this->getUserLangcode($event);
            $domain = pathinfo(env('APP_URL'))['basename'];
            Inside::js(
                'https://opt-out.ferank.eu/tarteaucitron.pro.js?locale='.$userLangcode.'&iswordpress=false&domain='
                .$domain.'&uuid='.env('COOKIE_BANNER_UUID').'&ver=5.3'
            );
        }

        // Jira report
        if (env('JIRA_REPORT_URI')) {
            Inside::headerJs(env('JIRA_REPORT_URI'));
        }
    }

    private function getUserLangcode(InsideBooted $event): string
    {
        $appLocal = config('app.locale');
        if ($event->application->runningInConsole()) {
            return $appLocal;
        }

        return Auth::user()?->langcode ?? $appLocal;
    }
}
