<?php

namespace Inside\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;

/**
 * Locale middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class LocaleMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        if (! $request->headers->has('api-token') || ! Auth::guard('api')->check()) {
            // Try to guess locale for page out of intranet ( login, reset password, etc... )
            $locale = collect($request->getLanguages())->first();
            if (str_contains($locale, '_')) {
                [$locale, $regional] = explode('_', $locale);
            }
            if (! is_string($locale) || ! in_array($locale, list_languages())) {
                $locale = config('app.locale');
            }
        } else {
            /** @var User $user */
            $user = Auth::user();
            $locale = $user->langcode;
        }
        if ($request->get('cypress', false) === true) {
            $locale = '__';
        }
        if ($locale === null) {
            // Fallback to default locale if we didn't find it!
            $locale = config('app.local') ?? env('APP_LOCALE', 'fr');
        }
        App::setLocale($locale);

        return $next($request);
    }
}
