<?php

namespace Inside\Http\Middleware\Headers;

use Closure;
use Illuminate\Http\Request;

/**
 * Security Header middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SecurityMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        $headers = [
            'Strict-Transport-Security' => 'max-age=31536000; includeSubDomains; preload',
            'X-XSS-Protection'          => '1; mode=block',
            'X-Frame-Options'           => 'ALLOW-FROM https://teams.microsoft.com',
            'X-Content-Type-Options'    => 'nosniff',
            'Referrer-Policy'           => 'strict-origin-when-cross-origin',
            'Vary'                      => 'Origin',
        ];

        $response = $next($request);

        foreach ($headers as $key => $value) {
            $response->headers->set($key, $value);
        }

        $response->headers->remove('X-Generator');
        // TODO : Doesn't work (See server configuration)
        $response->headers->remove('X-Powered-By');
        $response->headers->remove('Server');

        return $response;
    }
}
