<?php

namespace Inside\Http\Middleware\Headers;

use Closure;
use Illuminate\Http\Request;

/**
 * Feature Policy Header middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class FeaturePolicyMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        $policies = [
            'accelerometer        \'none\'',
            'ambient-light-sensor \'none\'',
            'autoplay             \'self\'',
            'camera               \'self\'',
            'encrypted-media      \'self\'',
            'fullscreen           \'self\' https://www.youtube.com https://player.vimeo.com',
            'geolocation          \'self\'',
            'gyroscope            \'none\'',
            'magnetometer         \'none\'',
            'microphone           \'none\'',
            'midi                 \'none\'',
            'payment              \'none\'',
            'speaker              \'none\'',
            'sync-xhr             \'self\'',
            'usb                  \'none\'',
            'vr                   \'none\'',
        ];

        $headers = [
            'Feature-Policy' => preg_replace('!\s+!', ' ', implode('; ', $policies)),
        ];

        $response = $next($request);

        foreach ($headers as $key => $value) {
            $response->headers->set($key, $value);
        }

        return $response;
    }
}
