<?php

namespace Inside\Http\Middleware\Headers;

use Closure;
use Illuminate\Http\Request;

/**
 * Expect CT Header middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ExpectCTMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        $reportURI = env('REPORT_URI', null) ? 'report-uri="'.env('REPORT_URI', null).'", ' : '';
        $headers = [
            'Expect-CT' => $reportURI.'max-age=31536000, enforce',
        ];

        $response = $next($request);

        foreach ($headers as $key => $value) {
            $response->headers->set($key, $value);
        }

        return $response;
    }
}
