<?php

namespace Inside\Http\Middleware\Headers;

use Closure;
use Illuminate\Http\Request;

/**
 * CORS middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AccessControlMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        $headers = [
            'Access-Control-Allow-Origin'  => '*',
            'Access-Control-Allow-Credentials' => 'true',
            'Access-Control-Allow-Methods' => 'GET, POST, PATCH, PUT, DELETE, OPTIONS',
            'Access-Control-Allow-Headers' => $request->header('Access-Control-Request-Headers'),
        ];

        if (env('APP_ENV', 'production') == 'production' && isset($_SERVER['HTTP_HOST'])
            && ! env('DISABLE_CORS_RESTRICTION', false)
        ) {
            $host = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http').'://'
                .str_replace('proxy.', '', $_SERVER['HTTP_HOST']);

            $headers['Access-Control-Allow-Origin'] = $host;
        }

        if (! $headers['Access-Control-Allow-Headers']) {
            $headers['Access-Control-Allow-Headers'] = '*';
        }

        if ($request->isMethod('OPTIONS')) {
            return response()->json('{"method":"OPTIONS"}', 200, $headers);
        }

        $response = $next($request);

        foreach ($headers as $key => $value) {
            $response->headers->set($key, $value);
        }

        return $response;
    }
}
