<?php

namespace Inside\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Inside\Application;
use Inside\Exceptions\MaintenanceModeException;

class CheckForMaintenanceMode
{
    protected array $except = [];

    public function __construct(
        protected Application $app
    ) {
    }

    /**
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if ($this->app->isDownForMaintenance() && ! $request->header('X-Bypass-Maintenance')) {
            $data = json_decode(file_get_contents($this->app->storagePath().'/framework/inside_down'), true);

            if ($this->inExceptArray($request)) {
                return $next($request);
            }

            throw new MaintenanceModeException($data['time'], $data['retry'], $data['message']);
        }

        return $next($request);
    }

    protected function inExceptArray(Request $request): bool
    {
        foreach ($this->except as $except) {
            if ($except != '/') {
                $except = trim($except, '/');
            }

            if ($request->fullUrlIs($except) || $request->is($except)) {
                return true;
            }
        }

        return false;
    }
}
