<?php

namespace Inside\Exceptions;

use function tap;
use Throwable;
use Whoops\Handler\PrettyPageHandler;
use Whoops\Run as Whoops;

class WhoopsExceptionRenderer
{
    public function render(Throwable $throwable): string
    {
        return tap(new Whoops(), function ($whoops) {
            $whoops->appendHandler($this->whoopsHandler());

            $whoops->writeToOutput(false);

            $whoops->allowQuit(false);
        })->handleException($throwable);
    }

    protected function whoopsHandler(): PrettyPageHandler
    {
        return (new WhoopsHandler())->forDebug();
    }
}
