<?php

namespace Inside\Exceptions;

use RuntimeException;

class JsonEncodingException extends RuntimeException
{
    /**
     * Create a new JSON encoding exception for the inside package
     *
     * @param mixed  $package
     * @param string $message
     * @return static
     */
    public static function forPackage($package, $message)
    {
        return new static('Error encoding package ['.$package->getName().'] to JSON: '.$message);
    }
}
