<?php

namespace Inside\Events;

use Illuminate\Database\Connection;
use Illuminate\Database\ConnectionInterface;

/**
 * Class SchemaDumped
 */
class SchemaDumped
{
    /**
     * Connection
     */
    public ConnectionInterface $connection;

    /**
     * Connection name
     */
    public ?string $connectionName;

    /**
     * Chemin vers le dump
     */
    public string $path;

    /**
     * Constructor
     *
     * @param Connection $connection
     * @param string $path
     * @return void
     */
    public function __construct(Connection $connection, string $path)
    {
        $this->connection = $connection;
        $this->connectionName = $connection->getName();
        $this->path = $path;
    }
}
