<?php

namespace Inside\Events;

use Closure;
use DateInterval;
use DateTimeInterface;
use Illuminate\Events\CallQueuedListener;
use Inside\Jobs\Queue\SerializableClosure;

class QueuedClosure
{
    public ?string $connection;

    public ?string $queue;

    public int|null|DateTimeInterface|DateInterval $delay;

    public array $catchCallbacks = [];

    /**
     * Create a new queued closure event listener resolver.
     */
    public function __construct(
        public Closure $closure
    ) {
    }

    public function onConnection(?string $connection): static
    {
        $this->connection = $connection;

        return $this;
    }

    public function onQueue(?string $queue): static
    {
        $this->queue = $queue;

        return $this;
    }

    public function delay(DateInterval|DateTimeInterface|int|null $delay): static
    {
        $this->delay = $delay;

        return $this;
    }

    public function catch(Closure $closure): static
    {
        $this->catchCallbacks[] = $closure;

        return $this;
    }

    public function resolve(): Closure
    {
        return function (...$arguments) {
            dispatch(new CallQueuedListener(InvokeQueuedClosure::class, 'handle', [
                'closure' => new SerializableClosure($this->closure),
                'arguments' => $arguments,
                'catch' => collect($this->catchCallbacks)->map(function ($callback) {
                    return new SerializableClosure($callback);
                })->all(),
            ]))->onConnection($this->connection)->onQueue($this->queue)->delay($this->delay);
        };
    }
}
