<?php

namespace Inside\Events;

use Inside\Jobs\Queue\SerializableClosure;
use Throwable;

class InvokeQueuedClosure
{
    public function handle(SerializableClosure $closure, array $arguments): void
    {
        call_user_func($closure->getClosure(), ...$arguments);
    }

    public function failed(SerializableClosure $closure, array $arguments, array $catchCallbacks, Throwable $exception): void
    {
        $arguments[] = $exception;

        collect($catchCallbacks)->each->__invoke(...$arguments); // @phpstan-ignore-line
    }
}
