<?php

namespace Inside\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Queue\SerializesModels;
use Inside\Facades\Version;

class InsideUpdated implements ShouldBroadcastNow
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public ?object $oldVersion = null
    ) {
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside');
    }

    public function broadcastAs(): string
    {
        return 'inside.updated';
    }

    public function broadcastWith(): array
    {
        return [
            'time' => now(),
            'version' => [
                'from' => $this->oldVersion,
                'to' => Version::get(),
            ],
        ];
    }
}
