<?php

namespace Inside\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class InsideIsAlive implements ShouldBroadcast
{
    public function broadcastOn(): Channel
    {
        return new Channel('inside');
    }

    public function broadcastAs(): string
    {
        return 'inside.alive';
    }

    public function broadcastWith(): array
    {
        return ['time' => now()];
    }
}
