<?php

namespace Inside\Database\Migrations;

use Symfony\Component\Console\Output\ConsoleOutput;

trait HasConsole
{
    /**
     * @var ConsoleOutput
     */
    protected $output;

    /**
     * @var array
     */
    protected $supportedColors = [
        'black',
        'red',
        'green',
        'yellow',
        'blue',
        'magenta',
        'cyan',
        'white',
        'default',
    ];

    protected function write(string $message): void
    {
        $this->getOutput()->write($message);
    }

    protected function writeln(string $message): void
    {
        $this->getOutput()->writeln($message);
    }

    protected function writeResult(bool $success): void
    {
        if ($success) {
            $this->writeln(' <fg=green>✔</fg=green>');

            return;
        }
        $this->writeln(' <fg=red>✘</fg=red>');
    }

    protected function separatorLine(?string $color = null): void
    {
        if (! in_array($color, $this->supportedColors)) {
            $color = null;
        }

        $colorOn = $color !== null ? '<fg='.$color.'>' : '';
        $colorOff = $color !== null ? '</fg='.$color.'>' : '';
        $this->writeln($colorOn.str_repeat('-', 80).$colorOff);
    }

    protected function getOutput(): ConsoleOutput
    {
        if ($this->output === null) {
            $this->output = new ConsoleOutput();
        }

        return $this->output;
    }
}
