<?php

namespace Inside\Database\Eloquent;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Builder as EloquentBuilder;
use Illuminate\Database\Eloquent\Model;

/**
 * @method LengthAwarePaginator fastPaginate(?int $perPage = null, array $columns = ['*'], string $pageName = 'page', ?int $page = null)
 * @method LengthAwarePaginator simpleFastPaginate(int $perPage = null, array $columns = ['*'], string $pageName = 'page', ?int $page = null)
 *
 * @mixin EloquentBuilder
 */
class Builder extends EloquentBuilder
{
    public function setModel(Model $model): self
    {
        $this->model = $model;

        $this->query->from($model->getTable());

        return $this;
    }

    public function withCasts(array $casts): self
    {
        // @phpstan-ignore-next-line
        $this->model->mergeCasts($casts);

        return $this;
    }

    /**
     * Increment a column's value by a given amount.
     *
     * @param string $column
     * @param int $amount
     * @param array $extra
     * @return int
     */
    public function increment($column, $amount = 1, array $extra = []): int
    {
        return $this->toBase()->increment(
            $column,
            $amount,
            $this->addUpdatedAtColumn($extra)
        );
    }

    /**
     * Decrement a column's value by a given amount.
     *
     * @param string $column
     * @param int $amount
     * @param array $extra
     * @return int
     */
    public function decrement($column, $amount = 1, array $extra = []): int
    {
        return $this->toBase()->decrement(
            $column,
            $amount,
            $this->addUpdatedAtColumn($extra)
        );
    }

    public function clone(): self
    {
        return clone $this;
    }

    public function __clone(): void
    {
        $this->query = clone $this->query;
    }
}
