<?php

namespace Inside\Console\Commands;

use Composer\Factory;
use Composer\IO\BufferIO;
use Inside\Console\Command;
use Symfony\Component\Console\Formatter\OutputFormatterStyle;
use Symfony\Component\Yaml\Yaml;

/**
 * Class VersionReload
 */
class VersionReload extends Command
{
    protected $signature = 'version:reload';

    protected $description = 'Reload inside version';

    public function handle(): void
    {
        $style = new OutputFormatterStyle('yellow', 'blue', []);
        $this->output->getFormatter()->setStyle('blue', $style);

        // Load from yaml
        try {
            $version = \Inside\Facades\Version::get();
            setting('system', ['version' => json_encode($version)]);
        } catch (\Exception $e) {
            // Mostly version.yml does not exist
            $defaultVersion = new \stdClass();
            $defaultVersion->major = 1;
            $defaultVersion->minor = 0;
            $defaultVersion->patch = '0-dev';
            setting('system', ['version' =>  json_encode($defaultVersion)]);
        }
        // reload version from settings
        $version = json_decode(setting('system', 'version', '{"major": 0, "minor": 0, "patch": 0}'));
        $this->output->writeln(
            '<blue> '.$version->major.'.'.$version->minor.'.'.$version->patch.' </blue>'
        );
        $this->line('');
    }
}
