<?php

namespace Inside\Console\Commands;

use Inside\Console\Command;

class UpdateThemeConfig extends Command
{
    protected $signature = 'inside:theme:update';

    protected $description = 'Mise-à-jour des paramètres du DSM depuis le front compilé!';

    public function handle(): void
    {
        $insideThemeConfigFilePath = theme_path('/assets/inside.theme.json');
        if (! file_exists($insideThemeConfigFilePath)) {
            $this->error('Le fichier de thème est introuvable. Assurez-vous que le front ce soit compilé avec succès!');

            return;
        }

        $fileContents = file_get_contents($insideThemeConfigFilePath);

        if ($fileContents === false) {
            $this->error('Impossible de lire le fichier de thème.');

            return;
        }

        setting('_theme', json_decode($fileContents, true));
        $this->info('Les paramètres de thème d\'Inside ont bien été mis à jour.');
    }
}
