<?php

namespace Inside\Console\Commands;

use Inside\Events\InsideUpdated;
use Inside\Facades\Version;
use Symfony\Component\Console\Formatter\OutputFormatterStyle;

class UpdateCommand extends InstallationTools
{
    protected $name = 'inside:update';

    protected $signature = 'inside:update {--no-cleaning : Ne pas lancer le nettoyage d\'Inside}';

    public function handle(): void
    {
        $this->line("Vérification du status d'installation d'inside");
        if (! $this->insideIsInstalled()) {
            $this->comment('Inside est n\' pas installé et va relancer la procédure d\'installation');
            $this->warn(str_repeat('#', 80));
            $this->call('inside:install');

            return;
        }

        $this->call('inside:down');

        $currentVersion = Version::get();

        $outputStyle = new OutputFormatterStyle('black', 'green');
        $this->output->getFormatter()->setStyle('inside', $outputStyle);
        $this->output->writeln('<inside>Début de la mise-à-jour d\'Inside</inside>');

        $this->checkStorage();

        $this->secureResources();

        $this->setAssetsLink();

        $this->setMenusLink();

        $this->upgradeDrupalSettings();

        $this->checkDrupal();

        $this->checkPublicLinks();

        $this->installNecessaryFiles();

        $this->createSymLinks();

        $this->checkAssets();

        $this->checkHorizonAssets();

        $this->patchVendors();

        $this->cleanupBasepath();

        $this->cleanCache();

        $this->reloadPackages();

        $this->cleanViewCache();

        $this->rebuildModels();

        $this->checkVersion();

        $this->checkJwtSecretAndSetIfNeeded();

        $this->removeDevelGenerateModule();

        $this->drush('cr');

        $this->drush('updb --yes');

        // TODO: to be removed after migration
        $this->drush('pm:enable path_alias --yes');

        $this->drush('inside:field-purge');

        $this->migrate();

        $this->queueRestart();

        // Rebuild again in case  migration changes something
        $this->rebuildModels();

        if (! $this->option('no-cleaning')) {
            $this->cleanUp();
        }

        $this->updateThemeConfig();

        $this->optimize();

        $this->updateInstalledLockFile();

        $this->rebuildTranslations();

        $this->addOneSignalFiles();

        $this->clearCacheRoute();

        $this->insideUpdatedSuccessfully();

        $this->call('inside:up');

        InsideUpdated::dispatch($currentVersion);

        $this->comment('[[Inside prêt]]');
    }
}
