<?php

namespace Inside\Console\Commands;

use Illuminate\Support\Facades\File;
use Inside\Console\Command;

class SecureResourcesCommand extends Command
{
    protected $signature = 'inside:secure:resources';

    protected $description = 'Secure resources from direct access';

    public function handle(): void
    {
        // Check system

        // Check server
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            // Assume iis server is running
            $this->comment('Windows détecté : installation pour IIS');
            $this->configureIis();
        } else {
            // unix like  machine, assume apache2 is running
            $this->comment('Unix like détecté : installation pour apache2');
            $this->configureApache2();
        }
        $this->info('Sécurisation terminée');
    }

    protected function configureApache2(): void
    {
        $htAccessFilePath = $this->getStoragePath().'/.htaccess';
        if (File::exists($htAccessFilePath)) {
            $this->comment('Fichier '.$htAccessFilePath.' déjà présent -> Réécriture');
            File::delete($htAccessFilePath);
        }

        if (config('app.disable_protected_files', false)) {
            return;
        }

        $content = <<<'CONTENT'
order deny,allow
deny from all
CONTENT;
        File::put($htAccessFilePath, $content);
    }

    protected function configureIis(): void
    {
        $webConfigPath = cms_base_path('vendor/maecia/'.config('app.code').'-back/web.config.client');
        if (! File::exists($webConfigPath)) {
            // Fallback to default inside one
            $webConfigPath = cms_base_path('vendor/maecia/inside-drupal/web/web.config');
        }

        $destPath = cms_base_path('web.config');
        if (File::exists($destPath)) {
            $this->comment('Fichier web.config déjà présent -> Réécriture');
            File::delete($destPath);
        }

        // Copy webConfig to root
        File::copy($webConfigPath, $destPath);
    }

    protected function getStoragePath(): string
    {
        $local = storage_path();
        if (config('app.app_storage_path')) {
            $local = cms_base_path(config('app.app_storage_path').'/..');
        }

        return $local;
    }
}
